﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucEventAddInstrument.ascx.cs" Inherits="ucEventAddInstrument" %>
OK

<script language="javascript" type="text/javascript">
    fnAddInstrumentValForm = function () {
        if (App.tfEITSearch.isValid()) {
            App.btnAddInstrumentSearch.setDisabled(false);
            App.btnEventInsSelOK.setDisabled(false);
        }
        else {
            App.btnAddInstrumentSearch.setDisabled(true);
            App.btnEventInsSelOK.setDisabled(true);
        }
    };

    
    function AriaEvtInsSelCancBtn(el) {
        el.set({
            "role": 'button'
        });
    }

    function AriaEASearchButton(el) {
        el.set({
            "role": 'button'
        });
    }

    
    function AriaEventInsSelBtn(el) {
        el.set({
            "role": 'button'
        });
    }

</script>
<ext:Window ID="wndEventAddInstrument"
    Title="Add Instrument(s)"
    Hidden="true"
    Layout="BorderLayout"
    Height="515"
    Width="720"
    IDMode="Static"
    runat="server"
    Constrain="true"
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn"
    >
    <Listeners>
        <BeforeShow Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();"></BeforeShow>
        <Hide Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        <Close Handler="App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
    </Listeners>
    <Items>
        <ext:FormPanel
            Margin="3"
            Region="North"
            Width="60" Padding="0"
            Border="false"
            Layout="AnchorLayout"
            runat="server">
            <Items>
                <ext:Panel
                    Border="false"
                    Layout="ColumnLayout"
                    runat="server" Width="720">
                    <Items>
                        <ext:Panel
                            runat="server"
                            Border="true"
                            BodyStyle="border: 1px solid lightgray;"
                            Margin="2"
                            Layout="ColumnLayout" Width="700">
                            <Items>
                                <ext:RadioGroup
                                    ID="rgEventInstrumentType"
                                    runat="server"
                                    Vertical="true"
                                    FieldLabel="Filter by"
                                    Width="350"
                                    LabelWidth="50"
                                    Margin="5">
                                    <Items>
                                        <ext:Radio MarginSpec="0 0 0 5"
                                            ID="rdoEITCPA"
                                            Width="160"
                                            BoxLabel="Clinical Program Area"
                                            runat="server">
                                        </ext:Radio>
                                        <ext:Radio MarginSpec="0 0 0 5"
                                            ID="rdoEITDisp"
                                            Width="85"
                                            BoxLabel="Disciplines"
                                            runat="server">
                                        </ext:Radio>
                                        <ext:Radio MarginSpec="0 0 0 5"
                                            ID="rdoEITAll"
                                            Width="80"
                                            BoxLabel="All"
                                            Checked="true"
                                            runat="server">
                                        </ext:Radio>
                                    </Items>
                                    <Listeners>
                                        <Change Handler="App.direct.UCEVENTADDINSTRUMENT.OnGroupTypeSelect();" />
                                    </Listeners>
                                </ext:RadioGroup>
                                <ext:TextField ID="tfEITSearch"
                                    Width="250"
                                    LabelWidth="50"
                                    runat="server"
                                    FieldLabel="Search"
                                    Vtype="alphanumXSS"
                                    Margin="5">
                                    <Listeners>
                                        <Change Fn="fnAddInstrumentValForm" />
                                    </Listeners>
                                </ext:TextField>
                                <ext:Button ID="btnAddInstrumentSearch" Text="Search" Handler="App.direct.UCEVENTADDINSTRUMENT.OnSearch();"
                                    runat="server"
                                    Icon="Magnifier"
                                    Margin="2" Padding="5">
                                    <Listeners>
                                        <AfterRender Handler="AriaEASearchButton(App.btnAddInstrumentSearch.getEl());" ></AfterRender>
                                    </Listeners>
                                </ext:Button>
                            </Items>
                        </ext:Panel>
                        
                    </Items>
                </ext:Panel>
                <ext:ComboBox
                    ID="cboEventInstrumentGroup"
                    runat="server"
                    Editable="false"
                    ValueField="MODULE_GROUP_ID"
                    DisplayField="MODULE_GROUP_DESCR"
                    AnchorHorizontal="99%"
                    FieldLabel="Choose Filter"
                    LabelWidth="80"
                    Padding="3">
                    <Store>
                        <ext:Store ID="storEventModuleGroups"
                            AutoLoad="true"
                            runat="server">
                            <Model>
                                <ext:Model ID="mdlEventGroupTypes"
                                    runat="Server"
                                    IDProperty="MODULE_GROUP_ID">
                                    <Fields>
                                        <ext:ModelField Name="MODULE_GROUP_ID" />
                                        <ext:ModelField Name="MODULE_GROUP_DESCR" />
                                    </Fields>
                                </ext:Model>
                            </Model>
                            <Reader>
                                <ext:JsonReader RootProperty="Tables[0].Rows">
                                </ext:JsonReader>
                            </Reader>
                        </ext:Store>
                    </Store>
                    <Listeners>
                        <Select Handler="App.direct.UCEVENTADDINSTRUMENT.OnGroupSelect();" />
                    </Listeners>
                </ext:ComboBox>
            </Items>
        </ext:FormPanel>
        <ext:GridPanel
            ID="gpEventInstruments"
            runat="server"
            Border="false"
            Layout="FitLayout"
            Padding="0"
            Region="Center"
            Title="Filtered Instruments"
            Flex="1"
            AutoScroll="true">
            <SelectionModel>
                <ext:CheckboxSelectionModel ID="smEventInstruments"
                    runat="server"
                    Mode="Simple">
                </ext:CheckboxSelectionModel>
            </SelectionModel>
            <ColumnModel runat="server">
                <Columns>
                    <ext:Column runat="server"
                        DataIndex="MODULE"
                        Text="Instrument Name"
                        Flex="48">
                        <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                    </ext:Column>
                    <ext:Column runat="server"
                        DataIndex="DESCRIPTION"
                        Text="Description"
                        Flex="48">
                        <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                    </ext:Column>
                </Columns>
            </ColumnModel>
            <Store>
                <ext:Store
                    ID="storEventInstruments"
                    AutoLoad="true"
                    runat="server">
                    <Model>
                        <ext:Model ID="mdlEventInstruments"
                            runat="Server"
                            IDProperty="MID">
                            <Fields>
                                <ext:ModelField Name="MID" />
                                <ext:ModelField Name="MODULE">
                                </ext:ModelField>
                                <ext:ModelField Name="MODULE_FOR" />
                                <ext:ModelField Name="DESCRIPTION">
                                </ext:ModelField>
                            </Fields>
                        </ext:Model>
                    </Model>
                    <Reader>
                        <ext:JsonReader RootProperty="Tables[0].Rows">
                        </ext:JsonReader>
                    </Reader>
                </ext:Store>
            </Store>
        </ext:GridPanel>
    </Items>
    <BottomBar>
        <ext:Toolbar ID="tbEventInstrumentSelection" runat="server">
            <Items>
                <ext:Button ID="btnEventInsSelOK"
                    runat="server"
                    Text="OK"
                    Icon="Disk"
                    Disabled="false">
                    <Listeners>
                        <AfterRender Handler="AriaEventInsSelBtn(App.btnEventInsSelOK.getEl());" ></AfterRender>
                    </Listeners>
                    <DirectEvents>
                        <Click OnEvent="OnInstrSelOK"
                            Before="App.btnEventInsSelOK.setDisabled(true)"
                            Success="App.btnEventInsSelOK.setDisabled(false);App.direct.UCINSTRUMENTSEL.ReloadPWEventNodes()">
                            <ExtraParams>
                                <ext:Parameter Name="gpSelParam"
                                    Value="Ext.util.Format.htmlEncode( Ext.encode(#{gpEventInstruments}.getRowsValues({selectedOnly : true})) )"
                                    Mode="Raw" />
                            </ExtraParams>
                        </Click>
                    </DirectEvents>
                </ext:Button>
                <ext:Button ID="btnEventInsSelCancel"
                    runat="server"
                    Text="Cancel"
                    Icon="Cancel"
                    Handler="App.wndEventAddInstrument.hide();" >
                    <Listeners>
                        <AfterRender Handler="AriaEvtInsSelCancBtn(App.btnEventInsSelCancel.getEl());" ></AfterRender>
                    </Listeners>
                </ext:Button>
            </Items>
        </ext:Toolbar>
    </BottomBar>
    <Listeners>
        <Show Handler="App.pnlMMenu.mask();App.vpMasterViewport.mask();" />
        <Close Handler="App.tfEITSearch.clear();App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
        <Hide Handler="App.tfEITSearch.clear();App.pnlMMenu.unmask();App.vpMasterViewport.unmask();" />
    </Listeners>
</ext:Window>
